﻿using System;
using System.Data.SQLite;
using DataAccess.DataTables;
using DataAccess.DataRows;

namespace DataAccess.TableAdapters
{
    public class MessageLinkTableAdapter
    {
        public MessageLinkDataRow FillByParent(int parent)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            MessageLinkDataTable dt = new MessageLinkDataTable();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand selectById = new SQLiteCommand(conn);
                selectById.CommandText = "SELECT * FROM MESSAGE_LINK WHERE PARENT = " + parent;

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectById);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            if (!success)
            {
                return null;
            }

            return dt[0];
        }

        public MessageLinkDataTable FillByChild(int child)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            MessageLinkDataTable dt = new MessageLinkDataTable();

            try
            {
                conn.Open();
                SQLiteCommand selectById = new SQLiteCommand(conn);
                selectById.CommandText = "SELECT * FROM MESSAGE_LINK WHERE CHILD = " + child;

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectById);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                dt = null;
            }
            finally
            {
                conn.Close();
            }

            return dt;
        }

        public bool insertMessageLink(int id, int parent, int child)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "INSERT INTO MESSAGE_LINK (ID, PARENT, CHILD) VALUES(" + id + "," + parent + "," + child + ")";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error inserting into MESSAGE_LINK table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }
    }
}